IF OBJECT_ID('P_EST_PED_CP_IT_COMPRADOR_APLICAR') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_PED_CP_IT_COMPRADOR_APLICAR
	END
GO
/*
Esta procedure roda dentro da P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL
*/
CREATE PROCEDURE P_EST_PED_CP_IT_COMPRADOR_APLICAR 
WITH ENCRYPTION
AS
BEGIN
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PED INT
DECLARE @CD_PROD INT
DECLARE @CD_COMPRADOR INT
PRINT 'VINCULANDO PEDIDO DE COMPRAS COM O COMPRADOR'
SET NOCOUNT ON
	delete
		cpp
	from
		EST_PED_CP_IT_PENDENCIA_COMPRADOR cpp INNER JOIN EST_PED_CP_IT_COMPRADOR cp ON
		cpp.CD_EMP = cp.CD_EMP AND
		cpp.CD_FILIAL = cp.CD_FILIAL AND
		cpp.CD_PED = cp.CD_PED AND
		cpp.CD_PROD = cp.CD_PROD 
		
		
	DECLARE AplicarCompradorPedidoCompras CURSOR FAST_FORWARD FOR
		SELECT
			p.CD_EMP,
			p.CD_FILIAL,
			p.CD_PED,
			p.CD_PROD,
			EST_PROD_COMPRADOR.CD_COMPRADOR
		FROM
			EST_PED_CP_IT_PENDENCIA_COMPRADOR p INNER JOIN EST_PROD_COMPRADOR_CPL pcpl ON
			p.CD_EMP = pcpl.CD_EMP AND
			p.CD_PROD = pcpl.CD_PROD 
			INNER JOIN EST_PROD_COMPRADOR ON 
			EST_PROD_COMPRADOR.CD_CTR = pcpl.CD_CTR

		OPEN AplicarCompradorPedidoCompras

		FETCH NEXT FROM AplicarCompradorPedidoCompras INTO @CD_EMP, @CD_FILIAL, @CD_PED, @CD_PROD,@CD_COMPRADOR

		WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT INTO EST_PED_CP_IT_COMPRADOR
				(CD_EMP,
				CD_FILIAL,
				CD_PED,
				CD_PROD,
				CD_COMPRADOR, 
				DT_CAD)
				SELECT       
					@CD_EMP,
					@CD_FILIAL, 
					@CD_PED,
					@CD_PROD,
					@CD_COMPRADOR,
					GETDATE()	
				WHERE NOT EXISTS (SELECT 1 
								  FROM EST_PED_CP_IT_COMPRADOR CP
								  WHERE CP.CD_EMP = @CD_EMP
								  AND CP.CD_FILIAL = @CD_FILIAL
								  AND CP.CD_PED = @CD_PED
								  AND CP.CD_COMPRADOR = @CD_COMPRADOR
								  AND CP.CD_PROD = @CD_PROD)
		
				FETCH NEXT FROM AplicarCompradorPedidoCompras INTO @CD_EMP, @CD_FILIAL, @CD_PED, @CD_PROD, @CD_COMPRADOR
			END
		PRINT 'Concludo.'

		CLOSE AplicarCompradorPedidoCompras;

		DEALLOCATE AplicarCompradorPedidoCompras;
END